#include <bits/stdc++.h>
using namespace std;
using ll = long long;

struct P {
    ll x, h;
    int i;
};

pair<ll, ll> pk(const P& a, const P& b) {
    ll d = b.x - a.x + b.h - a.h;
    ll v = d / 2;
    return {a.x + v, a.h + v};
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int n;
    cin >> n;
    vector<ll> X(n), H(n);
    for (auto& v : X) cin >> v;
    for (auto& v : H) cin >> v;
    
    vector<P> a(n);
    for (int i = 0; i < n; ++i) {
        a[i].x = X[i];
        a[i].h = H[i];
        a[i].i = i;
    }
    sort(a.begin(), a.end(), [](const P& p, const P& q) { return p.x < q.x; });
    
    vector<pair<ll, ll>> u;
    for (int i = 0; i + 1 < n; ++i) {
        u.push_back(pk(a[i], a[i + 1]));
    }
    
    vector<pair<ll, ll>> h;
    for (auto [x, y] : u) {
        while (h.size() >= 2) {
            auto [x2, y2] = h.back();
            auto [x1, y1] = h[h.size() - 2];
            if ((y2 - y1) * (x - x2) <= (y - y2) * (x2 - x1)) h.pop_back();
            else break;
        }
        h.emplace_back(x, y);
    }
    
    vector<ll> ans(n, -1);
    for (int i = 0; i < n; ++i) {
        ll cx = a[i].x, ch = a[i].h;
        ll best = 0; // ??? ??????
        
        auto it = lower_bound(h.begin(), h.end(), ch,
            [](const pair<ll, ll>& p, ll v) { return p.second < v; });
        
        if (it != h.end()) {
            best = min(best, abs(it->first - cx));
        }
        if (it != h.begin()) {
            --it;
            best = min(best, abs(it->first - cx));
        }
        
        if (i && a[i - 1].h >= ch) best = min(best, cx - a[i - 1].x);
        if (i + 1 < n && a[i + 1].h >= ch) best = min(best, a[i + 1].x - cx);
        
        ans[a[i].i] = best ? best : -1;
    }
    
    for (ll v : ans) cout << v << '\n';
}